<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class CompanyFeatureUsage extends Model
{
    protected $table = 'company_feature_usage';
    protected $primaryKey = 'Usage_id';
    public $timestamps = true;

    protected $fillable = [
        'Company_id',
        'Plan_id',
        'Subscription_id',
        'Feature_Name',
        'Usage_Count',
        'Max_Usage',
        'Start_Date',
        'End_Date',
    ];

    protected $casts = [
        'Usage_Count' => 'integer',
        'Max_Usage' => 'integer',
        'Start_Date' => 'datetime',
        'End_Date' => 'datetime',
        'Created_at' => 'datetime',
        'Updated_at' => 'datetime',
    ];

    public function company()
    {
        return $this->belongsTo(CompanyProfile::class, 'Company_id', 'Company_id');
    }

    public function plan()
    {
        return $this->belongsTo(Plan::class, 'Plan_id', 'Plan_id');
    }

    public function subscription()
    {
        return $this->belongsTo(Subscription::class, 'Subscription_id', 'Subscription_id');
    }
}
